# ---------------------------------------------------------------------------------------------------------------------
# PARAMETRY OPCJONALNE
# Te parametry mają rozsądne wartości domyślne.
# ---------------------------------------------------------------------------------------------------------------------

variable "db_name" {
  description = "Nazwa bazy danych."
  type        = string
  default     = null
}

variable "db_username" {
  description = "Nazwa użytkownika bazy danych."
  type        = string
  sensitive   = true
  default     = null
}

variable "db_password" {
  description = "Hasło bazy danych."
  type        = string
  sensitive   = true
  default     = null
}

variable "backup_retention_period" {
  description = "Dni, przez które będzie zachowana kopia zapasowa. Aby włączyć replikację, to musi być wartość większa niż 0."
  type        = number
  default     = null
}

variable "replicate_source_db" {
  description = "Jeżeli będzie podana, odbędzie się replikacja bazy danych RDS o podanym ARN."
  type        = string
  default     = null
}

